const express = require('express');
const fs = require('fs');
const https = require('https');
const { io } = require('socket.io-client');

const app = express();

function get_newer_file(dir, ext) {
    let files = fs.readdirSync(dir).filter(f => f.endsWith(ext));
    files.sort((a, b) => fs.statSync(dir + "/" + b).mtime.getTime() - fs.statSync(dir + "/" + a).mtime.getTime());
    return dir + "/" + files[0];
}

const cert = fs.readFileSync(get_newer_file("/home/socketdropp/ssl/certs", ".crt"));
const key = fs.readFileSync(get_newer_file("/home/socketdropp/ssl/keys", ".key"));

const https_options = { key, cert };

const socket = io("https://socket.dropapp.dev:5050", {
    transports: ["websocket"],
    rejectUnauthorized: false,
});

let socketConnected = false;
socket.on("connect", () => {
    socketConnected = true;
    console.log("onnected to Socket.IO server on 5050:", socket.id);
});
socket.on("disconnect", () => {
    socketConnected = false;
    console.log("Disconnected from Socket.IO server");
});

app.get('/api', (req, res) => {
    const { clinet_id, printer_id, url, msg, order_id, update_order_id } = req.query;

    
    if (!socketConnected) {
        return res.status(500).json({ code: 500, message: "Socket not connected yet" });
    } 
    
   //socket.emit('joinRoom', clinet_id); 

   if (!order_id && msg) {
        socket.emit('showMsg', [clinet_id, msg]);
        return res.json({ code: 200, message: `Sent msg >> ${msg}` });
    }
 
    if (order_id) {
        socket.emit('sendOrder', [clinet_id, order_id, msg]);
        return res.json({ code: 200, message: `Sent order >> ${order_id}` });
    }

    if (update_order_id) {
        socket.emit('sendUpdate', [clinet_id, update_order_id, msg]);
        return res.json({ code: 200, message: `Sent order update >> ${update_order_id}` });
    }

    if (printer_id) {
        socket.emit('sendPrint', [clinet_id, printer_id, url]);
        return res.json({ code: 200, message: 'Sent print command' });
    }

    res.json({ code: 400, message: 'No valid parameters provided' });
    
});

const port = 4747;
https.createServer(https_options, app).listen(port, () => {
    console.log(`✅ HTTPS API server running on port ${port}`);
});
