const express = require('express');
const socketIo = require('socket.io');

const app = express();
 
 
app.use(express.static(__dirname + '/public'));

const httpServer = app.listen(4949);
const io = socketIo(httpServer, {
    cors : {
        origin : '*'
    }
}); 
// secure: true ,
 
io.of('/').on('connection', (socket)=>{
        
     const sessionID = socket.id;
    // console.log("A new user connected: "+sessionID);
           
     socket.on('disconnect', function() {
        //console.log('user disconnect: '+sessionID);
     });
     
     
     
  
      socket.on('sendOrder', (data)=> {
         
        let roomName = data[0];
        console.log('roomName: '+roomName);
        
        socket.emit('sendOrder', 'roomName'); 
        
        const captcha = [data[1], data[2]];
        
        socket.broadcast.to(roomName).emit('receiveOrder', captcha);
                
     });
     
     
      socket.on('sendUpdate', (data)=> {
         
        let roomName = data[0];
        console.log('roomName: '+roomName);
        
        socket.emit('sendOrder', 'roomName'); 
        
        const captcha = [data[1], data[2]];
        
        socket.broadcast.to(roomName).emit('receiveOrderUpdate', captcha);
                
     });
     
      socket.on('showMsg', (data)=> {
         
        let roomName = data[0];
        console.log('roomName: '+roomName);
        
        socket.emit('showMsg', 'roomName'); 
        
        const captcha = [data[1]];
        
        socket.broadcast.to(roomName).emit('showMsg', captcha);
                
     });
     
     
     
     socket.on('sendPrint', (data)=> {
         
        let roomName = data[0];
        console.log('roomName: '+roomName);
        
        socket.emit('sendPrint', 'roomName'); 
        
        const captcha = [data[1], data[2]];
        
        socket.broadcast.to(roomName).emit('receivePrint', captcha);
                
     });
     
     
     
     

     socket.on('sendRefresh', (data)=> {
         
        let roomName = data[0];
        console.log('roomName: '+roomName);
        socket.broadcast.to(roomName).emit('sendRefresh', data[1]);
        //io.of('/').in(roomName).emit('sendRefresh', roomName);
        
                
     });
     
     socket.on('joinRoom', (data)=> {
         
        let roomName = data;
        console.log('roomName::: '+roomName);
        
        let lastRoomName = Array.from(socket.rooms)[1];
        socket.leave(lastRoomName);        
        
        socket.join(roomName);
        
        socket.emit('joinRoom', roomName); 
                
     });
     
     
});

 
 

 



 
 