const express = require('express');
const socketIo = require('socket.io');
const fs = require('fs');
let tls = require("tls");
const https = require('https');
function get_newer_file(dir,ext){
    var files = fs.readdirSync(dir);
    for(i=0;i<files.length;i++){
        if(!files[i].endsWith(ext)){
            files.splice(i,1);
        }
    }
    files.sort(function(a, b) {
               return fs.statSync(dir +"/"+ b).mtime.getTime() - 
                      fs.statSync(dir +"/"+ a).mtime.getTime();
    });
    return dir+"/"+files[0];
}
//  /home/chatmannnd/ssl/certs/
function ssl(domain,cb) {
    var cert = get_newer_file("/home/mannndavis/ssl/certs",".crt");
    cert = fs.readFileSync(cert, 'utf8');
    var key = get_newer_file("/home/mannndavis/ssl/keys",".key");
    key = fs.readFileSync(key, 'utf8'); 
    cb(null, new tls.createSecureContext({
        cert:cert,
        key:key,
    }));
}
const app = express();
const https_options = {
    //key: fs.readFileSync('p.key'),
    //cert: fs.readFileSync('c.crt'),
    //ca: fs.readFileSync('ca_bundle.crt'),
    SNICallback:ssl,
    requestCert: false,
    rejectUnauthorized: false
}
app.use(express.static(__dirname + '/public'));
const server = https.createServer(https_options, app);
server.listen(3002, function(){
    console.log('server started ok');
});
 
const io = socketIo(server, {
    cors : {
        origin : '*'
    },
    secure: true
}); 
// secure: true ,
 
io.of('/').on('connection', function(socket){
        
     const sessionID = socket.id;
    // console.log("A new user connected: "+sessionID);
           
     socket.on('disconnect', function() {
        //console.log('user disconnect: '+sessionID);
     });
     

      socket.on('newMessageFromClient', (data)=> {
         
        const captcha = [data[0], data[1]];
        
        console.log('server started ok'+data[0]);
         console.log(captcha);
 
        var currentRoomName = Array.from(socket.rooms)[1];
        io.of('/').in(currentRoomName).emit('newMessageFromServer', captcha);
                
     });
     
     socket.on('joinRoom', function(data){
         
        let roomName = data;
        //console.log('roomName25: '+roomName);
        
        let lastRoomName = Array.from(socket.rooms)[1];
        socket.leave(lastRoomName);        
        
        socket.join(roomName);
        
        socket.emit('joinRoom', roomName); 
                
     });
     
});

 
 

 



 
 